/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public abstract class CompositeCastingRecipe
extends MaterialCastingRecipe {
    public CompositeCastingRecipe(class_3956<?> type, class_2960 id, String group, IMaterialItem result, int itemCost) {
        super(type, id, group, class_1856.method_8091((class_1935[])new class_1935[]{result}), itemCost, result, true, false);
    }

    @Override
    protected Optional<MaterialFluidRecipe> getMaterialFluid(ICastingContainer inv) {
        return MaterialCastingLookup.getCompositeFluid(inv);
    }

    @Override
    public List<IDisplayableCastingRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            class_3956<?> type = this.method_17716();
            this.multiRecipes = MaterialCastingLookup.getAllCompositeFluids().stream().filter(recipe -> {
                MaterialVariant output = recipe.getOutput();
                MaterialVariant input = recipe.getInput();
                return !output.isUnknown() && input != null && !input.isUnknown() && !output.get().isHidden() && !input.get().isHidden() && this.result.canUseMaterial(output.getId()) && this.result.canUseMaterial(input.getId());
            }).map(recipe -> {
                List<FluidStack> fluids = this.resizeFluids(recipe.getFluids());
                long fluidAmount = fluids.stream().mapToLong(FluidStack::getAmount).max().orElse(0L);
                return new DisplayCastingRecipe(type, Collections.singletonList(this.result.withMaterial(Objects.requireNonNull(recipe.getInput()).getVariant())), fluids, this.result.withMaterial(recipe.getOutput().getVariant()), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), (long)this.itemCost * fluidAmount), this.consumed);
            }).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }

    public static class Serializer<T extends CompositeCastingRecipe>
    extends LoggingRecipeSerializer<T> {
        private final IFactory<T> factory;

        public T fromJson(class_2960 id, JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            IMaterialItem result = RecipeHelper.deserializeItem(class_3518.method_15265((JsonObject)json, (String)"result"), "result", IMaterialItem.class);
            int itemCost = class_3518.method_15260((JsonObject)json, (String)"item_cost");
            return this.factory.create(id, group, result, itemCost);
        }

        @Override
        @Nullable
        protected T fromNetworkSafe(class_2960 id, class_2540 buffer) {
            String group = buffer.method_10800(Short.MAX_VALUE);
            IMaterialItem result = RecipeHelper.readItem(buffer, IMaterialItem.class);
            int itemCost = buffer.method_10816();
            return this.factory.create(id, group, result, itemCost);
        }

        @Override
        protected void toNetworkSafe(class_2540 buffer, T recipe) {
            buffer.method_10814(((CompositeCastingRecipe)recipe).group);
            RecipeHelper.writeItem(buffer, ((CompositeCastingRecipe)recipe).result);
            buffer.method_10804(((CompositeCastingRecipe)recipe).itemCost);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    public static interface IFactory<T extends CompositeCastingRecipe> {
        public T create(class_2960 var1, String var2, IMaterialItem var3, int var4);
    }

    public static class Table
    extends CompositeCastingRecipe {
        public Table(class_2960 id, String group, IMaterialItem result, int itemCost) {
            super((class_3956)TinkerRecipeTypes.CASTING_TABLE.get(), id, group, result, itemCost);
        }

        public class_1865<?> method_8119() {
            return (class_1865)TinkerSmeltery.tableCompositeSerializer.get();
        }
    }

    public static class Basin
    extends CompositeCastingRecipe {
        public Basin(class_2960 id, String group, IMaterialItem result, int itemCost) {
            super((class_3956)TinkerRecipeTypes.CASTING_BASIN.get(), id, group, result, itemCost);
        }

        public class_1865<?> method_8119() {
            return (class_1865)TinkerSmeltery.basinCompositeSerializer.get();
        }
    }
}

